<?php
// app/Filament/Resources/KegiatanResource.php

namespace App\Filament\Resources;

use App\Filament\Resources\KegiatanResource\Pages;
use App\Models\Kegiatan;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;

class KegiatanResource extends Resource
{
    protected static ?string $model = Kegiatan::class;

    protected static ?string $navigationIcon = 'heroicon-o-academic-cap';
    protected static ?string $navigationGroup = 'Pelatihan';
    protected static ?int $navigationSort = 1;

    protected static ?string $modelLabel = 'Kegiatan';
    protected static ?string $pluralModelLabel = 'Kegiatan';
    protected static ?string $navigationLabel = 'Kegiatan';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('nama_pelatihan')
                    ->required()
                    ->maxLength(255)
                    ->label('Nama Pelatihan'),
                Forms\Components\TextInput::make('kode_pelatihan')
                    ->required()
                    ->unique(ignoreRecord: true)
                    ->label('Kode Pelatihan')
                    ->placeholder('Contoh: PMA-7, PP-9'),
                Forms\Components\DatePicker::make('tanggal_mulai')
                    ->required()
                    ->label('Tanggal Mulai'),
                Forms\Components\DatePicker::make('tanggal_selesai')
                    ->required()
                    ->label('Tanggal Selesai'),
                Forms\Components\TextInput::make('kuota')
                    ->numeric()
                    ->required()
                    ->minValue(1)
                    ->label('Kuota Peserta'),
                Forms\Components\Select::make('status')
                    ->options([
                        'active' => 'Aktif',
                        'inactive' => 'Nonaktif'
                    ])
                    ->required()
                    ->label('Status'),
                Forms\Components\Textarea::make('deskripsi')
                    ->columnSpanFull()
                    ->label('Deskripsi Pelatihan'),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('kode_pelatihan')
                    ->sortable()
                    ->searchable()
                    ->label('Kode'),
                Tables\Columns\TextColumn::make('nama_pelatihan')
                    ->searchable()
                    ->sortable()
                    ->label('Nama Pelatihan'),
                Tables\Columns\TextColumn::make('tanggal_mulai')
                    ->date()
                    ->sortable()
                    ->label('Mulai'),
                Tables\Columns\TextColumn::make('tanggal_selesai')
                    ->date()
                    ->sortable()
                    ->label('Selesai'),
                Tables\Columns\TextColumn::make('kuota')
                    ->label('Kuota')
                    ->sortable(),
                Tables\Columns\TextColumn::make('jumlah_peserta_diterima')
                    ->label('Terdaftar')
                    ->sortable(),
                Tables\Columns\TextColumn::make('kuota_tersedia')
                    ->label('Kuota Tersedia')
                    ->badge()
                    ->color(fn (string $state): string => match ($state) {
                        '1' => 'success',
                        '0' => 'danger',
                    })
                    ->formatStateUsing(fn ($state) => $state ? 'Tersedia' : 'Penuh'),
                Tables\Columns\BadgeColumn::make('status')
                    ->colors([
                        'success' => 'active',
                        'danger' => 'inactive',
                    ])
                    ->formatStateUsing(fn ($state) => $state === 'active' ? 'Aktif' : 'Nonaktif'),
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('status')
                    ->options([
                        'active' => 'Aktif',
                        'inactive' => 'Nonaktif'
                    ])
                    ->label('Status'),
                Tables\Filters\Filter::make('kuota_tersedia')
                    ->query(fn (Builder $query): Builder => $query->whereRaw('(SELECT COUNT(*) FROM pendaftarans WHERE pendaftarans.kegiatan_id = kegiatans.id AND status = "diterima") < kegiatans.kuota'))
                    ->label('Kuota Masih Tersedia'),
            ])
            ->actions([
                Tables\Actions\ViewAction::make(),
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListKegiatans::route('/'),
            'create' => Pages\CreateKegiatan::route('/create'),
            //'view' => Pages\ViewKegiatan::route('/{record}'),
            'edit' => Pages\EditKegiatan::route('/{record}/edit'),
        ];
    }
}