<?php
// app/Models/Kegiatan.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Kegiatan extends Model
{
    use HasFactory;

    protected $fillable = [
        'nama_pelatihan',
        'kode_pelatihan',
        'tanggal_mulai',
        'tanggal_selesai',
        'kuota',
        'status',
        'deskripsi',
    ];

    protected $casts = [
        'tanggal_mulai' => 'date',
        'tanggal_selesai' => 'date',
    ];

    public function pendaftarans(): HasMany
    {
        return $this->hasMany(Pendaftaran::class);
    }

    public function peserta()
    {
        return $this->hasManyThrough(Peserta::class, Pendaftaran::class, 'kegiatan_id', 'nik', 'id', 'peserta_nik');
    }

    // Hitung jumlah peserta yang diterima
    public function getJumlahPesertaDiterimaAttribute(): int
    {
        return $this->pendaftarans()->where('status', 'diterima')->count();
    }

    // Cek apakah kuota masih tersedia
    public function getKuotaTersediaAttribute(): bool
    {
        return $this->jumlah_peserta_diterima < $this->kuota;
    }

    // Scope untuk kegiatan aktif
    public function scopeAktif($query)
    {
        return $query->where('status', 'active');
    }
}