<?php
// app/Models/Peserta.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Peserta extends Model
{
    use HasFactory;

    protected $primaryKey = 'nik';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'nik',
        'nama',
        'tempat_lahir',
        'tanggal_lahir',
        'nomor_telepon',
        'agama',
        'jenis_kelamin',
        'status_pernikahan',
        'pendidikan_terakhir',
        'pekerjaan',
        'usaha_tani',
        'alamat_lengkap',
        'nama_poktan',
        'alamat_poktan',
        'nip',
        'email',
        'kabupaten_id',
    ];

    protected $casts = [
        'tanggal_lahir' => 'date',
    ];

    public function pendaftarans(): HasMany
    {
        return $this->hasMany(Pendaftaran::class, 'peserta_nik', 'nik');
    }

    public function kabupaten(): BelongsTo
    {
        return $this->belongsTo(Kabupaten::class);
    }

    // Accessor untuk usia
    public function getUsiaAttribute(): int
    {
        return now()->diffInYears($this->tanggal_lahir);
    }

    // Scope untuk peserta yang memenuhi syarat usia
    public function scopeMemenuhiSyaratUsia($query)
    {
        return $query->whereRaw('TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) <= 50');
    }
}