<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pendaftarans', function (Blueprint $table) {
            $table->id();
            $table->string('peserta_nik', 16);
            $table->foreignId('kegiatan_id')->constrained();
            $table->enum('status', ['pending', 'diterima', 'ditolak', 'selesai'])->default('pending');
            $table->timestamp('tanggal_daftar')->useCurrent();
            $table->text('catatan')->nullable();
            $table->timestamps();

            $table->foreign('peserta_nik')->references('nik')->on('pesertas')->onDelete('cascade');
            $table->unique(['peserta_nik', 'kegiatan_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pendaftarans');
    }
};